clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"	
	
*** Program to estimate revenue table

	import delimited "iri_wm_panel_new.csv"

	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Create WM post-entry and entry week indicator

	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		}
	egen wm = rowtotal(wm*)
	egen enter = rowtotal(enter*)
	
	encode market, gen(mkt)
	
** Setup
	rename iri_key stores
	xtset stores weekid
	
/*	egen dis = rowtotal(dis*)
	forvalues i=1/19 {
		capture gen dis`i'_2 = dis`i'^2
		capture gen dis`i'_3 = dis`i'^3
		}
	egen dis_sq = rowtotal(dis*_2)
	egen dis_cu = rowtotal(dis*_3)
	drop dis*_2 dis*_3
*/	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Create variables

	merge m:1 monthid using cpi.dta
	drop _merge
	
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen `var'_share = `var' / foodrev
		gen `var'_price = `var' / `var'_vol_sales
		drop `var' `var'_vol_sales
		}
		
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		qui sum `var'_share
		local `var'_mean_share = r(mean)
		gen `var'_weight_vol = ``var'_mean_share' * (`var'_price / cpi * 100)
		gen `var'_weight_avg = ``var'_mean_share' * (`var'_avg_price / cpi * 100)
		drop `var'_share
		}

	egen wp_vol = rowtotal(*_weight_vol)
	egen wp_avg = rowtotal(*_weight_avg)
	drop *_weight*

	gen logrev = log(foodrev / cpi * 100)
	gen logp_vol = log(wp_vol)
	gen logp_avg = log(wp_avg)
	
	compress
	
keep stores weekid enter wm wm_* chain mkt logrev logp* firmtype treat_nwm
		
** Regressions
	cd "\Results"
	
	foreach var of varlist logrev {
		reg `var' enter wm_1-wm_11 i.weekid, cluster(stores)
			outreg2 using final_`var', excel replace
		reg `var' enter wm_1-wm_11 i.mkt i.weekid, cluster(stores)
			outreg2 using final_`var', excel
		reg `var' enter wm_1-wm_11 i.chain i.mkt i.weekid, cluster(stores)
			outreg2 using final_`var', excel
		reg `var' enter wm_1-wm_11 i.chain i.mkt i.treat_nwm i.weekid, cluster(stores)
			outreg2 using final_`var', excel
		xtreg `var' enter wm_1-wm_11 i.weekid, fe cluster(stores)
			outreg2 using final_`var', excel
		xtreg `var' enter wm_1-wm_11 i.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid, fe cluster(stores)
			outreg2 using final_`var', excel
		xtreg `var' enter wm_1-wm_11 i.weekid i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, fe cluster(stores)
			outreg2 using final_`var', excel
			predict `var'_fe, u
		}
	
	gen wm_lt5 = wm_1+wm_3+wm_5	
	foreach var of varlist wm_lt5 {
		gen `var'_n1 = (`var'==1)
		gen `var'_n2 = (`var'==2)
		gen `var'_n3plus = (`var' > 2 & `var' < .)
		}	

	reghdfe logrev enter wm_lt5 i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, a(stores weekid) cluster(stores) keepsing
		outreg2 using final_rev, excel		
	reghdfe logrev enter wm_lt5_* i.mkt#c.weekid i.mkt#c.weekid#c.weekid i.treat_nwm#c.weekid i.treat_nwm#c.weekid#c.weekid, a(stores weekid) cluster(stores) keepsing
		outreg2 using final_rev, excel


		
	cd "J:\Dropbox\Projects\Walmart\IRI data\Results"	
	duplicates drop stores, force
	keep stores *_fe
	save fe.dta, replace
	
		
		
		